/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.model;

import jtbcore.exception.InvalidStateException;
import jtbcore.util.NumberUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ColumnModel {
    protected boolean primaryKey = false;
    protected boolean autoIncrement = false;
    protected boolean unique = false;
    protected String name;
    protected String type;
    protected Integer maxLen = null;

    public void loadNode(Node nodeColumn) throws InvalidStateException {
        NamedNodeMap attr = nodeColumn.getAttributes();
        this.name = attr.getNamedItem("name").getNodeValue();
        if (attr.getNamedItem("type") == null) {
            throw new InvalidStateException("type not set on column " + this.name);
        }
        this.type = attr.getNamedItem("type").getNodeValue();
        if (attr.getNamedItem("primary-key") != null && "true".equals(attr.getNamedItem("primary-key").getNodeValue())) {
            this.primaryKey = true;
        }
        if (attr.getNamedItem("autoincrement") != null && "true".equals(attr.getNamedItem("autoincrement").getNodeValue())) {
            this.autoIncrement = true;
        }
        if (attr.getNamedItem("auto-increment") != null && "true".equals(attr.getNamedItem("auto-increment").getNodeValue())) {
            this.autoIncrement = true;
        }
        if (attr.getNamedItem("unique") != null && "true".equals(attr.getNamedItem("unique").getNodeValue())) {
            this.unique = true;
        }
        if (this.type.contains("varchar")) {
            String len = this.type.replaceAll("varchar\\s*\\(.*?(\\d+).*", "$1");
            this.maxLen = NumberUtil.tryParseInt(len);
        }
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean u) {
        this.unique = u;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(Integer maxLen) {
        this.maxLen = maxLen;
    }
}

